// Info of each specific situation
let situationsInfo = {
  0: {
    title: "Mancanza di sorveglianza negli spazi pubblici",
    description: "Camminando di notte in un parco poco illuminato, nella speranza di prendere l'ultimo autobus per tornare a casa, senti dei passi dietro di te che ti fanno venire un brivido lungo la schiena. Aumenti il passo e noti un gruppo di persone che si aggira nell'ombra. Sentendoti vulnerabile, prendi il telefono per chiedere aiuto, ma la batteria è scarica. Senza sorveglianza, la tua ansia si intensifica, perché ti rendi conto che nessuno saprebbe se fosse successo qualcosa.",
    question: "Come ci si può sentire sicuri quando si naviga in spazi pubblici durante le ore di scarsa illuminazione o in aree scarsamente popolate?",
    booklet: "documents/pdf/booklet.pdf",
    pdfs: {
      0: {
        name: `L'impatto delle telecamere a circuito chiuso nelle pratiche di prevenzione della violenza e del crimine e l'istituzionalizzazione della sicurezza`,
        path: 'documents/situations/2/MAAT_Situation2_Resource5_2024.pdf'
      },
      1: {
        name: 'Gli effetti delle telecamere di sorveglianza sulla criminalità: Prove dalla metropolitana di Stoccolma',
        path: 'documents/situations/2/MAAT_Situation2_Resource6_2024.pdf'
      },
      2: {
        name: `Efficacia dell'installazione di telecamere a circuito chiuso nella prevenzione del crimine`,
        path: 'documents/situations/2/MAAT_Situation2_Resource7_2024.pdf'
      },
      3: {
        name: `L'effetto di prevenzione del crimine delle telecamere a circuito chiuso nei luoghi pubblici: un'analisi del punteggio di propensione`,
        path: 'documents/situations/2/MAAT_Situation2_Resource8_2024.pdf'
      },
      4: {
        name: 'Gli effetti della TVCC nella riduzione del crimine',
        path: 'documents/situations/2/MAAT_Situation2_Resource9_2024.pdf'
      }
    },
    links: {
      0: {
        name: `Spesa pubblica per l'ordine pubblico e la sicurezza`,
        path: 'https://ec.europa.eu/eurostat/statistics-explained/index.php?title=Government_expenditure_on_public_order_and_safety#Expenditure_on_.27public_order_and_safety.27'
      },
      1: {
        name: `Il valore delle telecamere di sorveglianza a circuito chiuso come strumento investigativo: Un'analisi empirica`,
        path: 'https://link.springer.com/article/10.1007/s10610-017-9341-6?utm_source=getftr&utm_medium=getftr&utm_campaign=getftr_pilot'
      },
      2: {
        name: 'TVCC e prevenzione del crimine',
        path: 'https://www.saferspaces.org.za/understand/entry/closed-circuit-television-cctv-and-crime-prevention'
      },
      3: {
        name: 'Sorveglianza a circuito chiuso per la prevenzione del crimine: Una revisione sistematica di 40 anni con meta-analisi',
        path: 'https://www.researchgate.net/publication/331981674_CCTV_surveillance_for_crime_prevention_A_40-year_systematic_review_with_meta-analysis'
      },
      4: {
        name: `L'internazionalizzazione della sorveglianza a circuito chiuso: Effetti sulla criminalità e implicazioni per le tecnologie emergenti`,
        path: 'https://www.crimrxiv.com/pub/sw8ljm5k/release/1'
      }
    },
    videos:  {},
    pdfsNum: 5,
    linksNum: 5,
    videosNum: 0,
  },  
  1: {
        title: "Servizi igienici pubblici accessibili e sicuri",
        description: "Stai camminando all'aperto e devi andare in bagno. Trovi una toilette in un bar: è piccola, sporca e si trova alla fine di un corridoio stretto e buio nel seminterrato dell'edificio.",
        question: "Come possono i servizi igienici pubblici puliti e sicuri migliorare la partecipazione pubblica delle donne e delle persone LGBTQIA+?",
        booklet: "documents/pdf/booklet.pdf",
        pdfs: {},
        links: {
          0: {
            name: 'La storia dei bagni pubblici femminili in Gran Bretagna',
            path: 'https://www.historic-uk.com/CultureUK/History-of-Womens-Public-Toilets-in-Britain/'
          },
          1: {
            name: 'La lotta per i servizi igienici pubblici nel Regno Unito',
            path: 'https://wash.leeds.ac.uk/womens-rights-and-the-loo-leash-the-fight-for-public-toilets-in-the-uk/'
          },
          2: {
            name: 'Strutture inadeguate ostacolano la mobilità sociale e finanziaria in India',
            path: 'https://feminisminindia.com/2022/07/04/public-toilets-for-women-inadequate-facilities-hamper-social-and-financial-mobility/'
          },
          3: {
            name: `Il Pakistan è tra i 10 paesi peggiori per l'accesso ai servizi igienici`,
            path: 'https://www.dawn.com/news/1744277'
          },
          4: {
            name: 'Il governo britannico vieta i servizi igienici di genere neutro',
            path: 'https://www.thepinknews.com/2023/08/13/gender-neutral-toilets-policy-kemi-badenoch/'
          },
          5: {
            name: 'I bagni neutri dal punto di vista del genere sono migliori per tutti',
            path: 'https://www.theguardian.com/commentisfree/2017/dec/01/gender-neutral-toilets-better-everybody-rage-latrine-trans-disabled'
          },
          6: {
            name: 'Mancanza di servizi igienici pubblici',
            path: 'https://www.bigissue.com/news/social-justice/public-toilets-uk-disabled-people/'
          },
          7: {
            name: 'I numeri dei servizi igienici nel mondo',
            path: 'https://www.qssupplies.co.uk/the-public-toilet-index.html'
          }
        },
        videos: {
          0: {
            name: 'Perché abbiamo bisogno di bagni neutri dal punto di vista del genere?',
            path: 'https://www.youtube.com/watch?v=XAcARiiK5uY'
          },
          1: {
            name: 'I bagni neutri per tutti gli utenti suscitano polemiche nelle scuole di Portland',
            path: 'https://www.youtube.com/watch?v=SJyKndYsmnM'
          },
          2: {
            name: 'Servizi igienici e genere: un discorso TED',
            path: 'https://www.youtube.com/watch?v=NCLoNwVJA-0'
          }
        },
        pdfsNum: 0,
        linksNum: 8,
        videosNum: 3,
  },
  2: {
        title: "Mancanza di spazi verdi adeguati per donne e ragazze",
        description: "Sei una giovane donna di vent'anni o di fine adolescenza che si dirige verso il parco del vostro quartiere preferito per godersi una bella giornata e fare una pausa pranzo. Una volta lì, vedi che tutti i posti a sedere sono già occupati da uomini o ragazzi, e ciò che rimane sono panchine rotte o chiazze di erba bagnata e fangosa su cui sedersi. Sei dispiaciuta di non poter godere di una bella giornata all'aperto e decidi di tornare a casa o sul posto di lavoro, o di rimanere in casa.",
        question: "Come si possono progettare gli spazi verdi di quartiere in modo che siano più invitanti per le donne e le ragazze?",
        booklet: "documents/pdf/booklet.pdf",
        pdfs: {},
        links: {
          0: {
            name: 'Come si progetta la città inclusiva in Europa e nella nostra regione?',
            path: 'https://www.gradnja.rs/planiranje-grada-po-meri-svih-ljudi-kako-se-to-radi-kod-nas-a-kako-u-evropi/'
          },
          1: {
            name: 'Come la pianificazione urbana ha reso una città migliore per le donne',
            path: 'https://slate.com/human-interest/2013/09/urban-planning-for-women-lets-all-move-to-vienna.html'
          },
          2: {
            name: 'Prospettiva trascurata: come la pianificazione urbana ignora le esigenze di donne e ragazze nello spazio pubblico',
            path: 'https://prostorikojipokrecu.ba/blog/zanemarena-perspektiva-kako-planiranje-prostora-ignorise-potrebe-djevojcica-i-zena/'
          },
          3: {
            name: 'Articolo di giornale: quali sono i luoghi più pericolosi per le donne in Serbia?',
            path: 'https://www.telegraf.rs/vesti/srbija/3462231-1-u-10-devojcica-do-15-godina-trpi-onlajn-nasilje-zene-u-srbiji-otkrile-koja-su-najopasnija-mesta-za-njih'
          },
          4: {
            name: 'Lo spazio pubblico deve essere sicuro per le donne - RAPPORTO UN HABITAT BiH',
            path: 'https://bosniaherzegovina.un.org/bhs/199998-javni-prostor-mora-biti-siguran-za-%C5%Beene'
          },
          5: {
            name: `Dal tramonto all'alba: esaminare le disuguaglianze di genere nelle economie urbane notturne - abstract del rapporto URBACT`,
            path: 'https://urbact.eu/knowledge-hub/gender-equal-cities/dusk-till-dawn-examining-gender-inequalities-urban-nighttime-economies?utm_source=brevo&utm_campaign=URBACT%20newsletter'
          },
          6: {
            name: 'Sicurezza delle donne e delle ragazze',
            path: 'https://worldurbanparks.org/blog/womens-and-girls-safety/'
          },
          7: {
            name: 'Parchi per adolescenti',
            path: 'https://www.childinthecity.org/2015/12/02/parks-for-teens-10-features-teens-want-to-see/?gdpr=deny'
          },
          8: {
            name: 'Ascoltare le storie delle donne',
            path: 'https://theconversation.com/to-design-safer-parks-for-women-city-planners-must-listen-to-their-stories-98317'
          },
          9: {
            name: 'Come progettare spazi pubblici per le ragazze',
            path: 'https://thiscitylife.ca/post/687162834878070784/how-to-design-public-spaces-for-girls'
          }
        },
        videos: {},
        pdfsNum: 0,
        linksNum: 10,
        videosNum: 0,
  },
  3: {
        title: "Mancanza di formazione e sensibilità nella polizia per affrontare le molestie.",
        description: "Sei uno/a studente/ssa universitario/a che torna a casa da solo/a di notte e ti senti insicuro/a. Ti imbatti in comportamenti sessualmente inappropriati e hai chiamato la polizia. Tuttavia, la polizia fa domande irrilevanti e non fornisce alcun supporto. Di conseguenza, vivi con disagio, temi per la tua sicurezza e sei restia a parlare, credendo che non verranno presi provvedimenti.",
        question: "Come possono le vittime sentirsi sicure nel denunciare e comunicare i casi che si verificano nei loro confronti?",
        booklet: "documents/pdf/booklet.pdf",
        pdfs: {
          0: {
            name: 'Why training is not improving the police response to sexual violence against women: A glimpse into the ‘black box’ of police training',
            path: 'documents/situations/4/MAAT_Situation4_Resource1_2024.pdf'
          },
          1: {
            name: `Dati e statistiche su stupri e tentativi di stupro da parte di European Women's Lobb`,
            path: 'documents/situations/4/MAAT_Situation4_Resource8_2024.pdf'
          },
          2: {
            name: 'Le conseguenze della pandemia di covid-19 sulle giovani donne migranti che vivono a Cipro',
            path: 'documents/situations/4/MAAT_Situation4_Resource9_2024.pdf'
          }
        },
        links:  {
          0: {
            name: `Protezione dallo sfruttamento e dall'abuso sessuale (PSEA)`,
            path: 'https://emergency.unhcr.org/protection/protection-principles/protection-sexual-exploitation-and-abuse-psea'
          },
          1: {
            name: 'Tre donne cercano ancora giustizia per casi di molestie sessuali',
            path: 'https://in-cyprus.philenews.com/local/three-women-still-seeking-justice-for-sexual-harassment-cases/'
          },
          2: {
            name: 'Cipro: un attacco alle donne di tutto il mondo',
            path: 'https://www.counterfire.org/article/cyprus-an-attack-on-women-everywhere/'
          },
          3: {
            name: `L'esposizione dello stupro a Cipro: Dalla scena del crimine all'aula di tribunale`,
            path: 'https://journals.sagepub.com/doi/full/10.1177/13657127231179284'
          },
          4: {
            name: 'Le ragazze e le donne sono la maggior parte delle vittime di violenza e abuso',
            path: 'https://cyprus-mail.com/2023/03/08/girls-and-women-the-majority-of-victims-of-violence-and-abuse/'
          },
          5: {
            name: 'Violenza contro le donne a Cipro: Nonostante gli sviluppi positivi, le vittime di stupro hanno bisogno di maggiore sostegno, secondo un nuovo rapporto',
            path: 'https://www.coe.int/en/web/portal/-/violence-against-women-in-cyprus-despite-positive-developments-rape-victims-need-more-support-says-new-report'
          }
        },
        videos:  {
          0: {
            name: 'La normalizzazione delle molestie sessuali sulle donne | Tobe Amamize | TEDxLSE',
            path: 'https://www.youtube.com/watch?v=6vJcDvaiVfI'
          }
        },
        pdfsNum: 3,
        linksNum: 6,
        videosNum: 1,
  },
  4: {
      title: "Molestie sessuali contro le donne e le persone LGBTQIA+",
      description: "In un vagone affollato della metropolitana, una donna sta premuta contro le porte, il suo disagio è evidente mentre un uomo dietro di lei la guarda e fa commenti inappropriati. Nonostante i suoi tentativi di ignorarlo, lui persiste, invadendo il suo spazio personale con avance indesiderate. La donna si sente sempre più vulnerabile e in trappola, mentre gli altri passeggeri guardano altrove, non volendo intervenire. Le molestie continuano fino a quando la donna esce dal treno, scossa e angosciata dalla situazione.",
      question: "Come possiamo prevenire e combattere le molestie sessuali e la violenza contro le persone LGBTQIA+?",
      booklet: "documents/pdf/booklet.pdf",
      pdfs: {
        0: {
          name: `Una lunga strada da percorrere per l'uguaglianza LGBTI`,
          path: 'documents/situations/0/MAAT_Situation0_Resource1_2020.pdf'
        },
        1: {
          name: 'Studio sulle aggressioni lgtbi-fobiche tra il  01/01/2019 e il 31/07/2019',
          path: 'documents/situations/0/MAAT_Situation0_Resource2_2019.pdf'
        },
        2: {
          name: 'Visibilità della lesbofobia. Compilazione di ricerca qualitativa lesbofobia ',
          path: 'documents/situations/0/MAAT_Situation0_Resource3_2021.pdf'
        },
        3: {
          name: 'Spatium urbis. Indagine sullo spazio urbano della città di Roma',
          path: 'documents/situations/0/MAAT_Situation0_Resource6_2024.pdf'
        },
        4: {
          name: 'Azione per la parità: Gli impegni di TfL per il 2020',
          path: 'documents/situations/0/MAAT_Situation0_Resource9_2020.pdf'
        }
      },
      links: {
        0: {
          name: 'La sensazione di insicurezza nei trasporti pubblici nella regione di Parigi nel 2019',
          path: 'https://www.institutparisregion.fr/nos-travaux/publications/le-sentiment-dinsecurite-dans-les-transports-collectifs-franciliens-en-2019/'
        },
        1: {
          name: `Le donne nel trasporto europeo con particolare attenzione alla ricerca e all'innovazione`,
          path: 'https://publications.jrc.ec.europa.eu/repository/handle/JRC117687'
        },
        2: {
          name: 'Esaminare la percezione della sicurezza delle donne durante i tempi di attesa nei terminal del trasporto pubblico',
          path: 'https://www.sciencedirect.com/science/article/abs/pii/S0967070X19307000',
        },
        3: {
          name: 'Transmobilità: mobilità, molestie e violenza subite dai passeggeri transgender e gender nonconforming del trasporto pubblico a Portland, Oregon',
          path: 'https://www.semanticscholar.org/paper/Transmobilities%3A-mobility%2C-harassment%2C-and-violence-Lubitow-Carathers/9ded58d6abb19871469795d3a8c5f9fb7ab7974f',
        },
        4: {
          name: 'Criminalità sui trasporti pubblici',
          path: 'https://link.springer.com/referenceworkentry/10.1007/978-1-4614-5690-2_301',
        }
      },
      pdfsNum: 5,
      linksNum: 5,
      videosNum: 0,
  },
}