/* 
 * Custom JS interactions
 */

var allPlayers = {};
let gameStarted = false;
let canRateIdeas =  false;
let gameFinished =  false;

async function getSettings() {
    try {
        const response = await $.ajax({
            type: 'POST',
            url: apiURLAdmin,
            dataType: 'json',
            data: {
                action: "getSettings"
            }
        });

        const data = response[0];
        const startDate = new Date(data.start_date);
        const remainingDaysIdeas = 13; //13
        const remainingDaysFinishCourse = 14; //14
        const endDateIdeas = new Date(startDate.getTime() + remainingDaysIdeas * 24 * 60 * 60 * 1000);
        const endDateFinishCourse = new Date(startDate.getTime() + remainingDaysFinishCourse * 24 * 60 * 60 * 1000);
        const currentDate = new Date();

        if (currentDate.toISOString().substr(0, 10) >= startDate.toISOString().substr(0, 10)) {
            gameStarted = true;
            if (currentDate.toISOString().substr(0, 10) >= endDateIdeas.toISOString().substr(0, 10)) {
                canRateIdeas = true;
                console.log('Posso votar')
                disableIdeaPlusIcon();
            } else {
                console.log('Posso acrescentar ideias')
            }

            if (currentDate.toISOString().substr(0, 10) > endDateFinishCourse.toISOString().substr(0, 10)) {
                gameFinished = true;
                gameStarted = false;
                courseComplete();
            }

        } else {
            gameStarted = false;
            gameFinished = false;
            courseStatus.startDate = startDate.toLocaleDateString();

        }
    } catch (error) {
        console.error('Error fetching settings:', error);
    }
}

function customFunctions() {
    getSettings().then((gameState) => {
        getGameStatus();
    })
}

function getGameStatus() {
    if(gameStarted && !gameFinished){
        console.log('Game on!')
        setTimeout(() => {
            goTo(1)
        }, 500);

        allPlayers = fetchAllPlayersData();
        setInterval(() => {
            allPlayers = fetchAllPlayersData();
            zork("Updating all players list...")
        }, 60000);
    } else if(!gameStarted && !gameFinished) {
        console.log('Game not started!')
        generateWaitScreen();
    } else {
        console.log('Game over!')
        generateGameoverScreen()
    }
}

function fetchAllPlayersData() {
    var pData = {};
    $.ajax({
        type: 'GET',
        url: apiURL + '?getAllPlayers',
        dataType: 'html',
        async: false,
        success: function(data) {
            if(data != "No lines found"){
                data = $.parseJSON(data);
                data.forEach((element, idx) => {
                    data[idx] = JSON.parse(element.pData)
                })
    
                pData = data;
            }
        }
    })

    return pData;
}

function generateWaitScreen() {
    $('#slide').remove()
    $('#slide-0').remove()
    let slide = document.createElement('div')
    let logo = document.createElement('img')
    let blob = document.createElement('img')
    let title = document.createElement('h2')
    let countdown = document.createElement('p')

    slide.classList.add('slide-countdown')
    blob.src = 'images/blob.png'
    blob.classList.add('blob-countdown')
    logo.src = 'images/logo.png'
    logo.classList.add('logo')
    logo.classList.add('logo-countdown')
    
    title.classList.add('title-countdown')
    countdown.classList.add('countdown')

    title.textContent = 'OOPS, THE GAME HASN’T STARTED YET.'
    countdown.textContent = 'The game will start on the ' + courseStatus.startDate

    $('#slide-container').append(slide)
    slide.append(logo)
    slide.append(blob)
    slide.append(title)
    slide.append(countdown)
}

function generateGameoverScreen() {
    $('#slide').remove()
    $('#slide-0').remove()
    let slide = document.createElement('div')
    let logo = document.createElement('img')
    let blob = document.createElement('img')
    let title = document.createElement('h2')
    let thanks = document.createElement('p')

    slide.classList.add('slide-countdown')
    blob.src = 'images/blob-gameover.png'
    blob.classList.add('blob-countdown')
    logo.src = 'images/logo.png'
    logo.classList.add('logo')
    logo.classList.add('logo-countdown')
    
    title.classList.add('title-countdown')
    thanks.classList.add('thanks')

    title.textContent = 'THE GAME HAS SUCCESSFULLY ENDED.'
    thanks.innerHTML = `Thank you for playing and participating<br>in the InclusiVille project!`

    $('#slide-container').append(slide)
    slide.append(logo)
    slide.append(blob)
    slide.append(title)
    slide.append(thanks)
}
function disableIdeaPlusIcon(){
    $('.add-idea').css({
        'display': 'none'
    })
}

function updateData() {
    $.ajax({
        type: 'POST',
        url: apiURL,
        dataType: 'json',
        async: true,
        data: {
            action: "updatePlayerData",
            identifier: courseStatus.identifier,
            data: JSON.stringify(courseStatus)
        },
        success: function(response) {
            zork("Player updated!")
            courseSave();
        }
    })
}
setInterval(() => {
    updateData()
}, 60000);

function GenerateIdentifier(){
    let rndString = 'maat';
    var characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
    var charactersLength = characters.length;
    for ( var i = 0; i < 20; i++ ) {
        rndString += characters.charAt(Math.floor(Math.random() * charactersLength));
    }

    if(CheckIdentifierExists(rndString)){
        pLogin();
    } else {
        courseStatus.identifier = rndString;
        pRegister();
    }
}

function CheckIdentifierExists(identifier){
    $.ajax({
        type: 'GET',
        url: apiURL + '?getIdentifier=' + identifier,
        dataType: 'html',
        success: function(data) {
            if(data == "Identifier exists!"){
                return true;
            }else{
                return false;
            }
        }
    })
}

async function pRegister(){
    $.ajax({
        type: 'POST',
        url: apiURL,
        dataType: 'json',
        async: true,
        data: {
            action: "registerPlayer",
            identifier: courseStatus.identifier,
            data: JSON.stringify(courseStatus)
        },
        success: function(response) {
            zork("Player registered!")
        },
        complete: function(){
            goTo(4)
        }
    })
   
}

function pLogin(){
    $.ajax({
        type: 'GET',
        url: apiURL + '?getPlayer=' + courseStatus.identifier,
        dataType: 'html',
        async: false,
        success: function(data) {
            getCivicBar();
            getRanking();
            if(data != "No identifier found"){
                var result = $.parseJSON(data)
                zork("Login player with email '" + courseStatus.playerEmail + "', identifier '" + result[0].identifier + "'")
                courseStatus = JSON.parse(result[0].pData)
            }else{
                zork("No player found with that email! Login failed.")
            }

        },
        complete: function(){
            goTo(4)
        }
    })
}

function getPlayerByIdentifier(){
    $.ajax({
        type: 'GET',
        url: apiURL + '?getPlayer=' + courseStatus.identifier,
        dataType: 'html',
        async: false,
        success: function(data) {
            if(data != "No identifier found"){
                var result = $.parseJSON(data)
                zork("I found the line below.")
            }else{
                zork("No data found!")
            }
        },
        complete: function(){
        }
    })
}

function parseData(saveData) {    
    Object.keys(saveData).forEach((index) => {
        const element = saveData[index];
        if (!isNaN(element)) {
            saveData[index] = parseFloat(element);
        }
    });

    courseSave();
}

function generateRanking() {
    $(".ranking .wrapper .ranking-row").remove();
    const rankingSection = $(".ranking .wrapper");

    // Agrupar jogador por pontos
    let playersByPoints = allPlayers.reduce((acc, player) => {
        if (!acc[player.playerPoints]) {
            acc[player.playerPoints] = [];
        }
        acc[player.playerPoints].push(player);
        return acc;
    }, {});

    // Get the keys of the object
    const keys = Object.keys(playersByPoints);
    let place = 0;

    // Iterate through the keys in reverse order
    for (let i = keys.length - 1; i >= 0; i--) {
        const keysInside = Object.keys(playersByPoints[keys[i]]);
        place++
        if(keysInside.length > 0){
            for (let index = 0; index < Object.keys(keysInside).length; index++) {
                let player = playersByPoints[keys[i]][index];
        
                $(rankingSection).append(`
                <div class="ranking-row">
                    <div class="ranking-img">
                        <img src="images/avatars/${player.playerAvatar}.png" alt="avatar image" class="ranking-avatar">
                        <div class="ranking-position">${place}${place == 1 ? 'st 🥇' : place == 2 ? 'nd 🥈' : place == 3 ? 'rd 🥉' : "th"}</div>
                    </div>
                    <div class="ranking-info-score">
                        <p class="ranking-name">${player.playerName}</p>
                        <p class="ranking-points">${player.playerPoints}</p>
                    </div>
                    <img src="images/badges/${player.playerBadge}.png" alt="badge image" class="ranking-badge">
                </div>`)
                
            }
        }
    }
}

function getRanking(){
    $.ajax({
        type: 'GET',
        url: apiURL + '?getRanking',
        dataType: 'html',
        async: false
    })
    updateData();
}

// Barra civica
function getCivicBar() {
    // Ir à BD buscar valores reais
    let ideasTarget = 10;
    let numPlayers = allPlayers.length;
    let numTotalIdeas = getIdeas().length;
    let ideasEvaluated = getRatingsCount().length;
    if(numPlayers == undefined){
        numPlayers = 0;
    }
    if(numTotalIdeas == undefined){
        numTotalIdeas = 0;
    }
    if(ideasEvaluated == undefined){
        ideasEvaluated = 0;
    }

    let mediaIdeas = (numTotalIdeas / numPlayers);

    let maxIdeasEvaluated = numPlayers * (numPlayers * mediaIdeas - mediaIdeas);

    let evaluationRacio = (ideasEvaluated / maxIdeasEvaluated) * 100;
    let evaluationPercentage = Math.trunc(evaluationRacio)
    
    let ideaRacio = (mediaIdeas / ideasTarget) * 100;
    let ideasPercentage = Math.trunc(ideaRacio)

    let finalBarRacio = (ideasPercentage * evaluationPercentage) / 100
    let finalBarPercentage = Math.trunc(finalBarRacio)
    document.getElementById('civicLevelBarCurrent').style.width = finalBarPercentage + '%'
}

setInterval(() => {
    getCivicBar()
}, 60000);


function loadGame() {
    getTotalStarsByPlayer()
    $('.playerName').html(courseStatus.playerName)
    setTimeout(() => {
        $('#totalPlayers').html(allPlayers.length)  
    }, 100);  
    $('.player-avatar').attr('src', `images/avatars/${courseStatus.playerAvatar}.png`)
    $('.stats-points-total').html(courseStatus.playerPoints)
    $('.stats-badge').attr('src', 'images/badges/' + courseStatus.playerBadge + '.png')
}

// Ideas functions
const savedIdeas = courseStatus.ideas;

function clearIdeas(){
    const savedIdeasContainer = document.getElementById('savedIdeas');
    savedIdeasContainer.innerHTML = "";
}

function showInput() {
    const inputContainer = document.getElementById('inputContainer');
    inputContainer.style.display = 'flex';
    document.getElementById('addIdeaButton').style.display = 'none';
    scrollToLastElement();
}

function saveIdea() {
    const inputField = document.getElementById('ideaInput');
    const ideaText = inputField.value.trim();
    if (ideaText) {
        savedIdeas.push(ideaText);
        inputField.value = ""; // Clear input field
        resetInput();
        sendIdeaToBD("saveIdea", null, ideaText);
        setTimeout(() => {
            clearIdeas();
            displayIdeas();
            scrollToLastElement();
            updatePoints();
        }, 100);
    }
}

function sendIdeaToBD(saveType = "saveIdea", ideaId, ideaText) {
    $.ajax({
        type: 'POST',
        url: apiURL,
        dataType: 'json',
        async: true,
        data: {
            action: saveType,
            identifier: courseStatus.identifier,
            idea: ideaText,
            situationId: courseStatus.lastSituation,
            ideaId: ideaId
        },
        success: function(response) {
            zork("Idea saved!")
        },
        complete: function(){
        }
    })

}

function getIdeas() {
    let ideas = [];
    $.ajax({
        type: 'GET',
        url: apiURL + '?getIdeas',
        dataType: 'html',
        async: false,
        success: function(data) {
            if(data != "No lines found"){
                var result = $.parseJSON(data)
                ideas = result
            }else{
                zork("No data found!")
            }
        }
    })
    return ideas;
}


function cancelIdea() {
    resetInput();
}

function resetInput() {
    const inputContainer = document.getElementById('inputContainer');
    inputContainer.style.display = 'none';
    document.getElementById('addIdeaButton').style.display = 'block';
}

function displayIdeas() {
    const savedIdeasContainer = document.getElementById('savedIdeas');
    var ideas = getIdeas();

    ideas = ideas.filter(idea => idea.idSituation == courseStatus.lastSituation.toString())

    ideas.forEach((idea, index) => {
        const ideaDiv = document.createElement('div');
        ideaDiv.classList.add('idea');

        function indentifierFound(player) {
            return player.identifier == idea.identifier;
        }
          
        const foundPlayer = allPlayers.find(indentifierFound);

        if(foundPlayer != undefined){

            // Avatar
            const playerAvatar = document.createElement('img');

            playerAvatar.src = `images/avatars/${foundPlayer.playerAvatar}.png`;
            playerAvatar.classList.add("player-avatar");
            ideaDiv.appendChild(playerAvatar);
            
            // Stars
            const playerStars = document.createElement('div');
            const playerStarsNum = document.createElement('p');
            const playerName = document.createElement('p');
            const playerStarsIcon = document.createElement('img');
            const playerRating = idea.rating > 0 ? idea.rating : 0;
            playerStarsNum.textContent = playerRating;
            playerStarsIcon.src = `images/icons/icon-star-full.png`;
            playerStars.appendChild(playerStarsNum);
            playerStars.appendChild(playerStarsIcon);
            playerStars.classList.add("player-stars");
            playerName.textContent = foundPlayer.playerName;
            playerName.classList.add("player-name-ideas");
            ideaDiv.appendChild(playerStars);
            ideaDiv.appendChild(playerName);

            // Idea
            const ideaText = document.createElement('p');
            const ideaId = document.createElement('span');
            ideaText.textContent = idea.textIdea;
            ideaText.classList.add("idea-text");
            ideaId.setAttribute("hidden", true)
            ideaId.textContent = idea.idIdea;
            ideaDiv.appendChild(ideaText);
            ideaDiv.appendChild(ideaId);

            // Votes só nas ideias dos outros
            if(courseStatus.identifier != idea.identifier){
                if(courseStatus.votedIdeas.indexOf(String(idea.idIdea)) >= 0){
                    let ideaLabel = document.createElement('p');
                    ideaLabel.classList.add("idea-feedback");
                    ideaLabel.textContent = "Thank you for your vote!";
                    ideaDiv.appendChild(ideaLabel);
                    ideaDiv.style.pointerEvents = 'none';
                } else {
                    const ideaVotes = document.createElement('div');
                    ideaVotes.classList.add("idea-votes");
                    if(canRateIdeas) {
                        ideaVotes.classList.add("visible");
                    }
        
                    const ideaVotesStarOne = document.createElement('img');
                    const ideaVotesStarTwo = document.createElement('img');
                    const ideaVotesStarThree = document.createElement('img');
                    const ideaVotesStarFour = document.createElement('img');
                    const ideaVotesStarFive = document.createElement('img');
        
                    ideaVotesStarOne.classList.add("idea-votes-star","idea-votes-star-1");
                    ideaVotesStarOne.setAttribute('data-value', 1);
                    ideaVotesStarTwo.classList.add("idea-votes-star","idea-votes-star-2");
                    ideaVotesStarTwo.setAttribute('data-value', 2);
                    ideaVotesStarThree.classList.add("idea-votes-star","idea-votes-star-3");
                    ideaVotesStarThree.setAttribute('data-value', 3);
                    ideaVotesStarFour.classList.add("idea-votes-star","idea-votes-star-4");
                    ideaVotesStarFour.setAttribute('data-value', 4);
                    ideaVotesStarFive.classList.add("idea-votes-star","idea-votes-star-5");
                    ideaVotesStarFive.setAttribute('data-value', 5);
        
                    ideaVotesStarOne.src = `images/icons/icon-star-empty.png`;
                    ideaVotesStarTwo.src = `images/icons/icon-star-empty.png`;
                    ideaVotesStarThree.src = `images/icons/icon-star-empty.png`;
                    ideaVotesStarFour.src = `images/icons/icon-star-empty.png`;
                    ideaVotesStarFive.src = `images/icons/icon-star-empty.png`;
            
                    ideaVotes.appendChild(ideaVotesStarOne);
                    ideaVotes.appendChild(ideaVotesStarTwo);
                    ideaVotes.appendChild(ideaVotesStarThree);
                    ideaVotes.appendChild(ideaVotesStarFour);
                    ideaVotes.appendChild(ideaVotesStarFive);
                    ideaDiv.appendChild(ideaVotes);
                }

            }

            // Edit btn só nas minhas ideias
            if(courseStatus.identifier == idea.identifier){
                const editButton = document.createElement('button');
                editButton.textContent = 'EDIT';
                editButton.classList.add("btn");

                editButton.onclick = () => editIdea(ideaDiv, idea.idIdea);
                ideaDiv.appendChild(editButton);

                if(canRateIdeas) {
                    editButton.classList.add("disabled");
                }
            }

            savedIdeasContainer.appendChild(ideaDiv);

        }
    });

    $('.idea-votes-star').click(function() {
        let starsParent = $(this).parent()
        let idea = $(starsParent).parent()
        let rating = $(this).attr('data-value');
        const idIdea = $(starsParent).prev().text();

        saveVoteToBD($(this).attr('data-value'), idIdea);
        for (let index = 1; index <= 5; index++) {
            if(rating >= index){
                $(starsParent).find('.idea-votes-star-' + index).attr('src', 'images/icons/icon-star-full.png');
                $(starsParent).css({'pointer-events': 'none'});
            }
        }
    });
    updateData();
}

function getRatingsByIdea(idIdea) {
    let rating = 0;
    $.ajax({
        type: 'GET',
        url: apiURL + '?getRatingsByIdea=' + idIdea,
        dataType: 'html',
        async: false,
        success: function(data) {
            if(data != "No ratings found"){
                rating = $.parseJSON(data);
                rating = rating[0].rating
                $('.idea').each(function(){
                    const spanIdIdea = $(this).find('span')
                    if($(spanIdIdea).text() == idIdea){
                        const spanParent = $(spanIdIdea).parent()
                        $(spanParent).find('.player-stars p').text(rating)
                    }
                })
            }
        }
    })
    return rating;
}

function getTotalStarsByPlayer() {
    $.ajax({
        type: 'GET',
        url: apiURL + '?getTotalStarsByPlayer=' + courseStatus.identifier,
        dataType: 'html',
        async: false,
        success: function(data) {
            if(data != "No ratings found"){
                starsData = $.parseJSON(data);

                const objetosFiltrados = starsData.find(objeto => objeto.identifier == courseStatus.identifier);
                courseStatus.playerStars = objetosFiltrados ? parseInt(objetosFiltrados.totalRating) : 0
                $('.stats-stars-total').html(courseStatus.playerStars);
                courseSave();
            }
        }
    })
}

function getRatingsCount() {
    let ratingCount = 0;
    $.ajax({
        type: 'GET',
        url: apiURL + '?getRatingsCount',
        dataType: 'html',
        async: false,
        success: function(data) {
            if(data != "No ratings found"){
                ratingCount = $.parseJSON(data);
            }
        }
    })
    return ratingCount;
}

function saveVoteToBD(rating, idIdea) {
    $.ajax({
        type: 'POST',
        url: apiURL,
        dataType: 'json',
        async: true,
        data: {
            action: "saveVote",
            identifier: courseStatus.identifier,
            idIdea: idIdea,
            rating: rating,
        },
        success: function(response) {
            zork("Vote submited!")
        },
        complete: function(){
            getRatingsByIdea(idIdea);
            courseStatus.votedIdeas.push(idIdea);
            updateData();
        }
    })
}

function editIdea(ideaElem, idIdea) {
    const ideaDiv = ideaElem;
    const ideaId = idIdea;
    const ideaText = ideaDiv.querySelector('.idea-text');
    const editInput = document.createElement('textarea');
    editInput.classList.add('editable');
    editInput.setAttribute("id", "ideaInput")
    editInput.setAttribute("max-length", "3000")

    editInput.value = ideaText.textContent;

    const saveButton = document.createElement('button');
    saveButton.textContent = 'SAVE';
    saveButton.classList.add("btn", 'btn-save');

    const cancelButton = document.createElement('button');
    cancelButton.textContent = 'CANCEL';
    cancelButton.classList.add("btn", 'btn-cancel');

    const newBtns  = document.createElement('div');
    newBtns.classList.add("new-btns");

    saveButton.onclick = () => saveEditedIdea(editInput.value, ideaId);
    cancelButton.onclick = () => cancelEditedIdea(index);

    ideaDiv.innerHTML = ''; // Clear existing content
    ideaDiv.appendChild(editInput);
    ideaDiv.appendChild(newBtns);
    newBtns.appendChild(saveButton);
    newBtns.appendChild(cancelButton);
}

function saveEditedIdea(updatedIdea, ideaId) {
    sendIdeaToBD("updateIdea", ideaId, updatedIdea);
    setTimeout(() => {
        clearIdeas();
        displayIdeas();
        scrollToLastElement(false)
    }, 100);
}

function cancelEditedIdea(index) {
    displayIdeas();
}

function scrollToLastElement(playAnim = true) {
    const container = document.getElementById('ideaContainer');
    const lastElement = container.lastElementChild;
    const scrollTo = lastElement.offsetLeft;

    if(playAnim) {
        container.scroll({ left: scrollTo, behavior: 'smooth' });
    } else {
        container.scroll({ left: scrollTo, behavior: 'auto' });
    }
}


// Game features functions
function openResources() {
    let situationId = $('#resourcesBtn').attr('data-value');
    console.log(situationId)

    switch(situationId) {
        case '0':
            $('.resources-block').fadeOut(800)
            $('.resources-block-0').fadeIn(800).css({'display':'flex'})
            break;
        case '1':
            $('.resources-block').fadeOut(800)
            $('.resources-block-1').fadeIn(800).css({'display':'flex'})
            break;
        case '2':
            $('.resources-block').fadeOut(800)
            $('.resources-block-2').fadeIn(800).css({'display':'flex'})
            break;
        case '3':
            $('.resources-block').fadeOut(800)
            $('.resources-block-3').fadeIn(800).css({'display':'flex'})
            break;
        case '4':
            $('.resources-block').fadeOut(800)
            $('.resources-block-4').fadeIn(800).css({'display':'flex'})
            break;
    }

    $('.cloud-curtin').addClass('cloudSweep')
    $('.cloud-curtin-left').addClass('cloudSweepRight')
    $('.cloud-curtin-right').addClass('cloudSweepLeft')
    setTimeout(() => {
        $('.resources-area').fadeIn(800)
        $('.situation-info').removeClass("slideLeft");
        $('.situations-area').fadeOut(800)
        $('.situation-info').addClass("slideLeft");
    }, 600);
    cloudCurtinAnimation()
}

function updatePoints(){

    // Code thats adds more points
    courseStatus.playerPoints += 100;
    let valueDisplays = document.getElementById('statsPoints');

    let startValue = $('#statsPoints').text();
    let startValueNum = parseInt(startValue);
    let endValue = courseStatus.playerPoints;
    
    if($(this).attr('data-points') != 0){
        let counter = setInterval(function(){
            startValueNum += 1;
            valueDisplays.textContent = startValueNum;
            if(startValueNum == endValue){
                playerSFXPlay("points", false)
                clearInterval(counter);
            }
        })   
    }   

    // Code that triggers new badge
    switch(courseStatus.playerPoints) {
        case 200:
            courseStatus.playerBadge = 1
            courseStatus.playerBadgeTitle = 'Silver Community Advocate'
            $('#statsBadge').attr('src', 'images/badges/1.png')
            $('#badgeImg').attr('src', 'images/badges/1.png')
            $('#badgeType').text(courseStatus.playerBadgeTitle)
            setTimeout(() => {
                $('.wrapper').show()
                earnNewBadge(1)
                badgeConfetti()
            }, 400);
            break;
        case 400:
            courseStatus.playerBadge = 2
            courseStatus.playerBadgeTitle = 'Golden Civic Leader'
            $('#statsBadge').attr('src', 'images/badges/2.png')
            $('#badgeImg').attr('src', 'images/badges/2.png')
            $('#badgeType').text(courseStatus.playerBadgeTitle)
            setTimeout(() => {
                $('.wrapper').show()
                earnNewBadge(2)
                badgeConfetti()
            }, 400);
            break;
        case 600:
            courseStatus.playerBadge = 3
            courseStatus.playerBadgeTitle = 'Empathy Ambassador'
            $('#statsBadge').attr('src', 'images/badges/3.png')
            $('#badgeImg').attr('src', 'images/badges/3.png')
            $('#badgeType').text(courseStatus.playerBadgeTitle)
            setTimeout(() => {
                $('.wrapper').show()
                earnNewBadge(3)
                badgeConfetti()
            }, 400);
            break;
        case 800:
            courseStatus.playerBadge = 4
            courseStatus.playerBadgeTitle = 'Innovative Solution Master'
            $('#statsBadge').attr('src', 'images/badges/4.png')
            $('#badgeImg').attr('src', 'images/badges/4.png')
            $('#badgeType').text(courseStatus.playerBadgeTitle)
            setTimeout(() => {
                $('.wrapper').show()
                earnNewBadge(4)
                badgeConfetti()
            }, 400);
            break;
        case 1000:
            courseStatus.playerBadge = 5
            courseStatus.playerBadgeTitle = 'Energizer of inclusive cities'
            $('#statsBadge').attr('src', 'images/badges/5.png')
            $('#badgeImg').attr('src', 'images/badges/5.png')
            $('#badgeType').text(courseStatus.playerBadgeTitle)

            setTimeout(() => {
                $('.wrapper').show()
                $('.new-badge .badge-text-final').show()
                earnNewBadge(5)
                badgeConfetti()
            }, 400);
            break;
    }

    updateData();
}

function earnNewBadge() {
    $('.new-badge').css({'display': 'flex'}).fadeIn()
    setTimeout(() => {
        playerSFXPlay('badge')
    }, 200);
}

function previousInstruction() {
    var id = $('.instruction-slide.active').data('instruction-slide');
    var idParent = $('.instruction-slide.active').parent().data('instruction');
    var idPrev = id - 1;
    
    if ( $('#instruction-slide-'+idParent+'-'+idPrev).length > 0 ) {
        $('.instruction-slide.active').removeClass('active');
        $('.instruction-slide').hide()
        $('#instruction-slide-'+idParent+'-'+idPrev).addClass('active');
        $('#instruction-slide-'+idParent+'-'+idPrev).show()
    }
}

function nextInstruction() {
    var id = $('.instruction-slide.active').data('instruction-slide');
    var idParent = $('.instruction-slide.active').parent().data('instruction');
    var idNext = id + 1;
    
    if ( $('#instruction-slide-'+idParent+'-'+idNext).length > 0 ) {
        $('.instruction-slide.active').removeClass('active');
        $('.instruction-slide').hide()
        $('#instruction-slide-'+idParent+'-'+idNext).addClass('active');
        $('#instruction-slide-'+idParent+'-'+idNext).show()
    }
}


// Simple functions for details
function cloudsSweep() {
    $('.cloud-curtin-left').addClass('cloudSweepRight')
    $('.cloud-curtin-right').addClass('cloudSweepLeft')
    $('.situationNav').css({'pointer-events':'none'})
    cloudCurtinAnimation()
}

function cloudCurtinAnimation() {

    /*
    const clouds = document.getElementById("cloudCurtin");

    clouds.addEventListener('animationend', () => {
        $('.situation-hotspot ').removeClass('hotspotFlip')
        $('.cloud-curtin').removeClass('cloudSweep')
        $('#goBackSituation').css({'pointer-events':'all'})
    });
    */

    // Once the clouds sweep animation is hover, we go into the new area
    const cloudsRight = document.getElementById("cloudCurtinRight");
    const cloudsLeft = document.getElementById("cloudCurtinLeft");

    //Add animation event listener, with attached function.
    cloudsRight.addEventListener('animationend', () => {
        $('.situation-hotspot ').removeClass('hotspotFlip')
        $('.cloud-curtin-right').removeClass('cloudSweepLeft')
        $('.situationNav').css({'pointer-events':'all'})
    });
    cloudsLeft.addEventListener('animationend', () => {
        $('.situation-hotspot ').removeClass('hotspotFlip')
        $('.cloud-curtin-left').removeClass('cloudSweepRight')
        $('.situationNav').css({'pointer-events':'all'})
    });
}

function markCheckbox(){
    if( courseStatus.checkbox == 0){
        courseStatus.checkbox = 1
    } else {
        courseStatus.checkbox = 0;
    }
}

function badgeConfetti() {
    // Whenever you get a new badge, a screen enters and this animation plays out
    for (var i = 0; i < 150; i++) {
        create(i);
    }
    
    function create(i) {
        var colourIdx = Math.ceil(Math.random() * 3);
        var colour = "pink";
        switch(colourIdx) {
        case 1:
            colour = "red";
            break;
        case 2:
            colour = "purple";
            break;
        default:
            colour = "pink";
        }
        $('<div class="confetti-'+i+' '+colour+'"></div>').css({
        "width" : "5px",
        "height" : "10px",
        "top" : -Math.random()*20+"%",
        "left" : Math.random()*100+"%",
        "transform" : "rotate("+Math.random()*360+"deg)"
        }).appendTo('.wrapper');  
        drop(i);
    }
    
    function drop(x) {
        $('.confetti-'+x).animate({
            top: "100%",
            left: "+="+Math.random()*15+"%"
            }, Math.random()*2000 + 2000, function() {
            setTimeout(() => {
                $('.wrapper').hide()
                $('.confetti').css({
                    'top':'0',
                    'left':'0'
                })
            }, 500);
        });
    }
}

function openInstructions() {
    $('.instructions-area').show();
    $('.instructions-area').css({
        'background-color': 'var(--clr-bg-blur-dk)',
    })
    $('.instructions-slide').hide();
    $('#instruction-button-window-0, #instruction-button-window-0 #instruction-slide-0-0').show();
    $('#instruction-button-window-0, #instruction-button-window-0 #instruction-slide-0-0').addClass('active');
}

function closeInstructions() {
    $('.instructions-area').hide()
    $('.instruction-slide').removeClass('active');
    $('.instruction-slide').hide();
}


// PDF Viewer
function OpenExternalPopup(link){
    // Fixes dual-screen position                             Most browsers      Firefox
    const dualScreenLeft = window.screenLeft !==  undefined ? window.screenLeft : window.screenX;
    const dualScreenTop = window.screenTop !==  undefined   ? window.screenTop  : window.screenY;

    const width = window.innerWidth ? window.innerWidth : document.documentElement.clientWidth ? document.documentElement.clientWidth : screen.width;
    const height = window.innerHeight ? window.innerHeight : document.documentElement.clientHeight ? document.documentElement.clientHeight : screen.height;
    const w = 1200;
    const h = 800;

    const systemZoom = width / window.screen.availWidth;
    const left = (width - w) / 2 / systemZoom + dualScreenLeft
    const top = ((height - h) / 2 / systemZoom + dualScreenTop) + 80

    window.open(link, '_blank', `toolbar=0,location=0,menubar=0,width=1200,height=800,top=${top},left=${left}`);
}



var adminAreaKeys = { 
    65: 'a',
    68: 'd',
    73: 'i',
    78: 'n',
    77: 'm',
  };
  
var adminAreaCode = [ 'a', 'd', 'm', 'i', 'n'];
  
var adminAreaPosition = 0;

document.addEventListener('keydown', function(e) {
    // get the value of the key code from the key map
    var key = adminAreaKeys[e.keyCode];
    // get the value of the required key from the konami code
    var requiredKey = adminAreaCode[adminAreaPosition];

    // compare the key with the required key
    if ( key == requiredKey ) {

	// move to the next key in the konami code sequence
	adminAreaPosition++;

	// if the last key is reached, activate cheats
	if ( adminAreaPosition == adminAreaCode.length ) {
	    openAdminPopup();
	    adminAreaPosition = 0;
	}
    } else {
        adminAreaPosition = 0;
    }
});

function openAdminPopup() {
    OpenExternalPopup(apiURLAdmin.replace("api.php", "index.php?lang=en"))
}

function goHome() {
    $('.situations-area').fadeOut(800)
    $('.situation-info').removeClass("slideLeft");
    $('.situation-info').removeClass("slideRight");
    $('.ideas-area').fadeOut(800)
    $('.resources-area').fadeOut(800)
}