----- DOCUMENTATION -----
Tool used: https://readme.so/
# MAAT | InclusiVille: Youth-driven civic engagement
This project is a WP3 non-formal education project, developed by European partners, as an answer to a complex and last-longing problem: 

## Index
[Link to Goals](#goals)
[Link to Roadmap](#Roadmap)
[Link to Concept](#Concept)
[Link to Scope](#Scope)
[Link to Features](#Features)
[Link to Installation](#Installation)
[Link to FAG](#FAQ)


## Goals
These are the goals proposed for this project:
- Promote non-formal learning and active participation among young people and youth organisations.
- Increase citizen civic engagement competences in youth.
- Potentiate know-how to participate in decision making processes.
- Foster youth participation in institutional political processes and policy-making.
- Raise awareness on the impacts and dangerousness of urban intersectional gender discrimination and biases.
- Promote in youth the belief that their action can shape how a city functions.

**Note:** These specific objectives contribute to all MAAT general objectives of promoting evidence-based urban policy making anchored in the real needs of the population that uses a city, in particularly women, with a intersectional gender lens; supporting the educational and personal development of young people; promoting cooperation, quality, inclusion and equity, excellence, creativity and innovation at the level of youth organisations; and promoting non-formal learning and active participation among young people.

## Roadmap
### How to achieve the objectives?
The previous listed objectives will be achieved by designing, developing, validating and testing a state-of-the-art non-formal education programme, based on: 
- A gamified learning experience, with a strong social component;
- Three sessions and support PowerPoints for face-to-face session activities, with dynamization techniques;
- An interactive flipbook.

## Concept and Requirements
### Pedagogical Concept
The non-formal education programme will be based on a gamification methodological approach, where an interactive social network will be developed where youth will share their ideas on urban planning with a gender lens and will have the ability to rate ideas based on their potential application and outcomes. This online social network will be a city virtual simulator where youth will truly impact that city with their actions.

### Creative Concept
We will have a scenario with a city on the background, and hotspots that will take the player to a specific scenario screen. There will be an always-available-interactable component, in which the players will be able to access more information, write down ideas to solve/help fix the specific scenario presented and access boobklets/resources.

### Techinal Requirements
- Youth people that can engage online, from anywhere, if they have an internet connection and a computer, tablet or smartphone.
- The realisation of this experience (SCORM - LMS) presupposes the use of a Database and a BackOffice, where it will be possible to manage all the training - start and end dates, participants, among others.

## Scope
The project is divided by 2 main "areas":
1- Intro
2- City

### Intro Section
The Intro Section will be further divided in more "sub-areas":
1.1- Sound warning
1.2- Tutorial snippets
1.3- Registration form

With this section, we want to ensure the player is in a adequate space to listen and interact with the game, to explain how will it work and to save the players information, that later will allow them to enter the game again and see all the results and ideas already written in previous accesses.

### City Section
The City Section will be further divided in more "sub-areas":
2.1 - City view
2.2 - Specific scenarios
2.3 - Ideas/Info/Resources component
2.4 - Resources
2.5 - Ranking
2.6 - "Logout" zone

With this section, we want the player to not only understand the general topic discussed and presented in this game, but to be confrontend with actual real situations tyhat happen everyday, across Europe. By preseting real situations, we will allow the players to write more consice and tangible ideas, that can be discussed and acted on after this entire Learning Path is completed.

## Features
In order for the participants see each other's ideas and information, we created variables in which we will store gama data throughout the course. These variables are:

#### Player
- playerName: player's name/nickname choosen
- playerEmail: player's email picked
- playerAvatar: player's avatar picked

#### Gameplay
- playerPoints: all points gained by adding ideas
- playerStars: all stars gained from others' evaluations
- playerBadge: the current stage we are in  terms of points
- playerBadgeTitle: the title connected to that specific badge

#### General
- interations
- situations
- ideas

## Installation
TBD
    
## FAQ
TBD
