<?php
	header('Content-Type: text/html; charset=utf-8');
	
	$valid_passwords = array ('ADMIN' => 'ADMIN');
	$valid_users = array_keys($valid_passwords);
	
	if (isset($_SERVER['PHP_AUTH_PW']) && isset($_SERVER['PHP_AUTH_USER'])){
		$user = $_SERVER['PHP_AUTH_USER'];
		$pass = $_SERVER['PHP_AUTH_PW'];

		$validated = (in_array($user, $valid_users)) && ($pass == $valid_passwords[$user]);
		
		if (!$validated) {
			header('WWW-Authenticate: Basic realm="Login:"');
			header('HTTP/1.0 401 Unauthorized');
			die ("Login incorreto.");
		}
	} else {
		header('WWW-Authenticate: Basic realm="Login:"');
		header('HTTP/1.0 401 Unauthorized');
		die ("Login incorreto.");
	}

	// Colocar o campo de data inicial, nao colocar de data final~
	
	if(isset($_GET["lang"])){
    	
    	// Translations
    	$translation["en"][0] = "SET STARTING DATE";
    	$translation["en"][1] = "UPDATE";
    	$translation["en"][2] = "Start Date";
    	$translation["en"][3] = "End Date";
    	$translation["en"][4] = "Total Users";

		$translation["el"][0] = "ΟΡΙΣΜΟΣ ΗΜΕΡΟΜΗΝΙΑΣ ΕΝΑΡΞΗΣ";
    	$translation["el"][1] = "ΕΚΣΥΓΧΡΟΝΙΖΩ";
    	$translation["el"][2] = "Ημερομηνία έναρξης";
    	$translation["el"][3] = "Ημερομηνία λήξης";
    	$translation["el"][4] = "Σύνολο χρηστών";

    	$translation["it"][0] = "IMPOSTARE LA DATA DI INIZIO";
    	$translation["it"][1] = "AGGIORNAMENTO";
    	$translation["it"][2] = "Data d'inizio";
    	$translation["it"][3] = "Data di fine";
    	$translation["it"][4] = "Totale utenti";

		$translation["ro"][0] = "STABILIREA DATEI DE ÎNCEPERE";
    	$translation["ro"][1] = "UPDATE";
    	$translation["ro"][2] = "Data de începere";
    	$translation["ro"][3] = "Data de încheiere";
    	$translation["ro"][4] = "Total utilizatori";

		$translation["rs"][0] = "PODESI POČETNI DATUM";
    	$translation["rs"][1] = "UPDATE";
    	$translation["rs"][2] = "Start Date";
    	$translation["rs"][3] = "rsd Date";
    	$translation["rs"][4] = "Total Users";
    	
    
    	$lang = $_GET["lang"];
	}else{
	    exit();
	}
	

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>MAAT - Admin Area</title>
</head>

<style>
	:root {
		/* TYPOGRAPHY */
		--ft-h1: 3.25rem;
		--ft-h2: 1.875rem;
		--ft-text-lg: 1.75rem;
		--ft-text-md: 1.5rem;
		--ft-text-sm: 1.25rem;

		/* COLORS */
		--clr-primary: #FF636C;
		--clr-primary-darker: #c9474e;
		--clr-secondary: #5D2576;
		--clr-text-dark: #939393;
		--clr-text-light: #FFFFFF;
		--clr-bg: #FFF8F9;
		--clr-bg-blur-dk: rgba(0, 0, 0, .85);
		--clr-bg-blur-lt: rgba(255, 255, 255, .3);
		--clr-grad: linear-gradient(90deg, rgba(255,99,108,1) 0%, rgba(93,37,118,1) 100%);
		--clr-area: linear-gradient(133deg, rgba(253,99,108,1) 0%, rgba(166,59,75,1) 76%);
	}

	html {
		background-image: url(./images/bg.png);
		text-align: center;
	}
    body {
        font-family: 'Montserrat', sans-serif;
    }
    table {
        border-collapse: collapse;
    }
    th {
        font-size: 22px;
        background: var(--clr-grad);
    	color: #fff;
		border: 1px solid #8f3136;
		padding: 12px 20px;
    }
    td {
        border: 1px solid #8f3136;
        font-size: 20px;
        padding: 8px;
		color: #000;
		font-weight: normal;
    }
	.logo {
		position: absolute;
		top: 40px;
		left: 40px;
		width: 100px;
	}
	.btn {
		background: rgb(255,99,108);
		background: var(--clr-grad);
		color: var(--clr-text-light);
		border-radius: 40px;
		border: none;
		padding: 12px 32px;
		cursor: pointer;
		transition: transform 0.25s ease;
		font-size: 16px;
		font-weight: bold;
	}
	.game-settings {
		margin-top: 180px;
		background-color: #fff;
		width: 80%;
		margin-inline: auto;
		border-radius: 20px;
		padding: 40px;
	}
	.game-settings-dates {
		display: flex;
		flex-direction: column;
		align-items: center;
		gap: 12px;
	}
	.game-settings-results {
		text-align: left;
    	margin-inline: auto;
		margin-top: 40px;
	}
</style>

<body>
	<img src="images/logo.png" alt="" class="logo">

    <div class="game-settings">
        <h2 style="color: #FF636C;font-size: 2rem;"><?php echo $translation[$lang][0]; ?></h2>
        <div class="game-settings-dates">
            <input type="date" class="game-idea-optimal" id="newDate" style="font-size: 18px">
            <button type="submit" onclick="updateSettings()" class="btn"><?php echo $translation[$lang][1]; ?></button>
        </div>
		<table class="game-users-results game-settings-results">
            <tr>
              <th><?php echo $translation[$lang][2]; ?></th>
              <th><?php echo $translation[$lang][3]; ?></th>
              <th><?php echo $translation[$lang][4]; ?></th>
            </tr>
            <tr>
              <td></td>
              <td></td>
              <td></td>
            </tr>
        </table>

    </div>
</body>
<script src="jquery.min.js"></script>
<script>
	function getSettings() {
		$.ajax({
			type: 'POST',
			url: "api.php",
			dataType: 'json',
			async: true,
			data: {
				action: "getSettings"
			},
			success: function(response) {
				const data = response[0]
				const startDate = new Date(data.start_date);
				const remainingDays = 14; //14
				const endDate = new Date(startDate.getTime() + remainingDays*24*60*60*1000);

				$('.game-settings-results td:nth-child(1)').text(startDate.toLocaleDateString())
				$('.game-settings-results td:nth-child(2)').text(endDate.toLocaleDateString())
				$('.game-settings-results td:nth-child(3)').text(data.TotalUsers)
			}
		})
	}

	function updateSettings() {
		$.ajax({
			type: 'POST',
			url: "api.php",
			dataType: 'json',
			async: true,
			data: {
				action: "updateSettings",
				newDate: $('#newDate').val()
			},
			complete: function(){
				getSettings()
			}
		})
	}

	$(document).ready(() => {
		getSettings()
	})
</script>

</html>