/* 
 *      Main course configuration here
 */

var autoLLWindow = false;	    // Automatically launch LLWINDOW
var godMode = false;		    // You are now a GOD! Inside this course...
var zorkMode = false;		    // Makes the course talk, or not...
var courseMode = 'scorm';	    // Save method: 'local', 'scorm', 'arthur' ou other...
var amnesiaMode = false;	    // Makes the course forgetful...
var adminMode = false;

var playerSize = 'scale';	    // Set to optimal, ou scale
var playerPosition = 'top';	    // Set to center, fit, top or bottom, only works if playerSize = 'optimal'
var playerControls = 'width';	    // Player controls are adjusted to the 'width' of the slide or not (false)
var playerWidth = 1920;                 
var playerHeight = 1080;
var playerAudioOn = true;
var playerPreload = false;		    // Preload how many slides?
var playerHomeStandard = true;      //After HOME is achieved, always go to HOME when revisitng to the course
var playerHome = 0;
var playerHorizontal = true;	    // Does the player need to be horizontal?
var playerFullscreenMobile = true;  // Should the player become full-screen on mobile phones?
var playerBigBG = true;
var playerTransition = false;       //Either 'fade' or false
var playerBigBG = true;
var playerSubTitle = true;
var playerProgressBar = true;
var playerAudioWarning = false;

var coursePrecedence = false;
var courseEndStatus = 'completed';
var courseFailStatus = 'failed';

let ideasTarget = 10;

var courseStatus = {         // User Status, update according to project
    audio: 1,		         // Audio on or off
    music: 0,                // Music on or off
    progress: -1,	         // User progress / Slides viewed
    completed: 0,	         // Did the user complete the course?
    position: 0,	         // User's last viewed slide
    grade: 0,
    checkbox: 0,
    booklet: 0,
    bookletGame: 0,
    identifier: '',

    // Player login info - Saved in the registation
    playerName: '',
    playerEmail: '',
    playerAvatar: 0, // Needs to be null

    // Player stats - Saved throughout the course
    playerPoints: 0,
    playerStars: 0,
    playerBadge: 0,
    playerBadgeTitle: 'Bronze Civic Contributor',
};

if ( courseStatus.animate === undefined ) {
    courseStatus.animate = new Array;
}
if ( courseStatus.situations === undefined ) {
    courseStatus.situations = new Array;
}
if ( courseStatus.ideas === undefined ) {
    courseStatus.ideas = new Array;
}
if ( courseStatus.resourcesClicked === undefined ) {
    courseStatus.resourcesClicked = new Array;
}
if ( courseStatus.votedIdeas === undefined ) {
    courseStatus.votedIdeas = new Array;
}

function courseSaveImportantStuff() {
    var saveData = '';
    
    saveData += 'audio' + ':' + courseStatus.audio;
    saveData += '|';
    saveData += 'music' + ':' + courseStatus.music;

    return saveData;    
}

function courseSaveCheckpointStuff() {
    var saveData = '';
    
    saveData += 'audio' + ':' + courseStatus.audio;
    saveData += '|';
    saveData += 'music' + ':' + courseStatus.music;
    saveData += '|';
    saveData += 'progress' + ':' + courseStatus.checkpoint;
    saveData += '|';
    saveData += 'position' + ':' + courseStatus.checkpoint;
    saveData += '|';
    saveData += 'score' + ':' + courseStatus.checkpoint_score;
    saveData += '|';
    saveData += 'score_1' + ':' + courseStatus.checkpoint_score_1;
    saveData += '|';
    saveData += 'score_2' + ':' + courseStatus.checkpoint_score_2;
    saveData += '|';
    saveData += 'score_3' + ':' + courseStatus.checkpoint_score_3;
    saveData += '|';
    saveData += 'medal_1' + ':' + courseStatus.checkpoint_medal_1;
    saveData += '|';
    saveData += 'medal_2' + ':' + courseStatus.checkpoint_medal_2;
    saveData += '|';
    saveData += 'medal_3' + ':' + courseStatus.checkpoint_medal_3;
    saveData += '|';
    saveData += 'health' + ':' + courseStatus.checkpoint_health;
    saveData += '|';
    saveData += 'lives' + ':' + courseStatus.checkpoint_lives;
    saveData += '|';
    saveData += 'character' + ':' + courseStatus.checkpoint_character;
    saveData += '|';
    saveData += 'nickname' + ':' + courseStatus.checkpoint_nickname;
    
    var checkpoint_sim = courseStatus.checkpoint_sim;
    
    for ( i = 0; i < checkpoint_sim; i++ ) {
	saveData += '|';
	saveData += 'sim_points[' + i + ']' + ':' + courseStatus.sim_points[i];
	saveData += '|';
	saveData += 'sim_percentage[' + i + ']' + ':' + courseStatus.sim_percentage[i];
	saveData += '|';
	saveData += 'sim_time_taken[' + i + ']' + ':' + courseStatus.sim_time_taken[i];
	saveData += '|';
	saveData += 'sim_time_left[' + i + ']' + ':' + courseStatus.sim_time_left[i];
    }

    return saveData;
}
function courseMakeCheckpoint() {
    courseStatus.checkpoint = courseStatus.position;
    courseStatus.checkpoint_sim = courseStatus.sim_points.length;
    courseStatus.checkpoint_score = courseStatus.score;
    courseStatus.checkpoint_score_1 = courseStatus.score_1;
    courseStatus.checkpoint_score_2 = courseStatus.score_2;
    courseStatus.checkpoint_score_3 = courseStatus.score_3;
    courseStatus.checkpoint_medal_1 = courseStatus.medal_1;
    courseStatus.checkpoint_medal_2 = courseStatus.medal_2;
    courseStatus.checkpoint_medal_3 = courseStatus.medal_3;
    courseStatus.checkpoint_health = courseStatus.health;
    courseStatus.checkpoint_lives = courseStatus.lives;
    courseStatus.checkpoint_character = courseStatus.character;;
    courseStatus.checkpoint_nickname = courseStatus.nickname;;
    zork( 'Checkpoint!' );
    courseSave();
}

const apiURL = 'https://example.com/api/api.php';
const apiURLAdmin = 'https://example.com/admin/api.php';
