// Info of each specific situation
let situationsInfo = {
  0: {
    title: "Lack of surveillance in public spaces",
    description: "Walking through a dimly lit park at night, hoping to catch the last bus home, you hear footsteps behind you, sending a chill down your spine. You increase your pace and notice a group of people loitering in the shadows. Feeling vulnerable, you reach for your phone to call for help, but your battery is dead. Without surveillance, your anxiety intensifies, realising no one would know if something happened.",
    question: "How can people feel safe when navigating public spaces during low-light hours or in sparsely populated areas?",
    booklet: "documents/pdf/booklet.pdf",
    pdfs: {
      0: {
        name: 'The Impact of CCTV in Violence and Crime Prevention Practice and the Institutionalisation of Safety',
        path: 'documents/situations/2/MAAT_Situation2_Resource5_2024.pdf'
      },
      1: {
        name: 'The Effects of Surveillance Cameras on Crime: Evidence from the Stockholm Subway',
        path: 'documents/situations/2/MAAT_Situation2_Resource6_2024.pdf'
      },
      2: {
        name: 'Effectiveness of CCTV Cameras Installation In Crime Prevention',
        path: 'documents/situations/2/MAAT_Situation2_Resource7_2024.pdf'
      },
      3: {
        name: 'The crime prevention effect of CCTV in public places: a propensity score analysis',
        path: 'documents/situations/2/MAAT_Situation2_Resource8_2024.pdf'
      },
      4: {
        name: 'The Effects of CCTV in Reducing Crime',
        path: 'documents/situations/2/MAAT_Situation2_Resource9_2024.pdf'
      }
    },
    links: {
      0: {
        name: 'Government expenditure on public order and safety',
        path: 'https://ec.europa.eu/eurostat/statistics-explained/index.php?title=Government_expenditure_on_public_order_and_safety#Expenditure_on_.27public_order_and_safety.27'
      },
      1: {
        name: 'The Value of CCTV Surveillance Cameras as an Investigative Tool: An Empirical Analysis',
        path: 'https://link.springer.com/article/10.1007/s10610-017-9341-6?utm_source=getftr&utm_medium=getftr&utm_campaign=getftr_pilot'
      },
      2: {
        name: 'CCTV and Crime Prevention',
        path: 'https://www.saferspaces.org.za/understand/entry/closed-circuit-television-cctv-and-crime-prevention'
      },
      3: {
        name: 'CCTV surveillance for crime prevention: A 40‐year systematic review with meta‐analysis',
        path: 'https://www.researchgate.net/publication/331981674_CCTV_surveillance_for_crime_prevention_A_40-year_systematic_review_with_meta-analysis'
      },
      4: {
        name: 'The Internationalization of CCTV Surveillance: Effects on Crime and Implications for Emerging Technologies',
        path: 'https://www.crimrxiv.com/pub/sw8ljm5k/release/1'
      }
    },
    videos:  {},
    pdfsNum: 5,
    linksNum: 5,
    videosNum: 0,
  },  
  1: {
        title: "Accessible and safe public toilets",
        description: "You are walking outside and have to go to the toilet. You find a toilet in a café: it is small, dirty, and at the end of a dark and narrow corridor in the basement of the building.",
        question: "How can clean and safe public toilets improve public participation for women and LGBTQIA+ people?",
        booklet: "documents/pdf/booklet.pdf",
        pdfs: {},
        links: {
          0: {
            name: 'The History of Women’s Public Toilets in Britain',
            path: 'https://www.historic-uk.com/CultureUK/History-of-Womens-Public-Toilets-in-Britain/'
          },
          1: {
            name: 'The fight for public toilets in the UK',
            path: 'https://wash.leeds.ac.uk/womens-rights-and-the-loo-leash-the-fight-for-public-toilets-in-the-uk/'
          },
          2: {
            name: 'Inadequate Facilities Hamper Social And Financial Mobility in India',
            path: 'https://feminisminindia.com/2022/07/04/public-toilets-for-women-inadequate-facilities-hamper-social-and-financial-mobility/'
          },
          3: {
            name: 'Pakistan is among the 10 worst countries for access to toilets',
            path: 'https://www.dawn.com/news/1744277'
          },
          4: {
            name: 'Uk government bans gender-neutral toilets',
            path: 'https://www.thepinknews.com/2023/08/13/gender-neutral-toilets-policy-kemi-badenoch/'
          },
          5: {
            name: 'Gender-neutral toilets are better for everyone',
            path: 'https://www.theguardian.com/commentisfree/2017/dec/01/gender-neutral-toilets-better-everybody-rage-latrine-trans-disabled'
          },
          6: {
            name: 'A lack of public toilets',
            path: 'https://www.bigissue.com/news/social-justice/public-toilets-uk-disabled-people/'
          },
          7: {
            name: 'Toilets numbers in the world',
            path: 'https://www.qssupplies.co.uk/the-public-toilet-index.html'
          }
        },
        videos: {
          0: {
            name: 'Why do we need gender-neutral bathrooms?',
            path: 'https://www.youtube.com/watch?v=XAcARiiK5uY'
          },
          1: {
            name: 'All-user gender-neutral bathrooms causing controversy in Portland schools',
            path: 'https://www.youtube.com/watch?v=SJyKndYsmnM'
          },
          2: {
            name: 'Toilets and gender: a TED talk',
            path: 'https://www.youtube.com/watch?v=NCLoNwVJA-0'
          }
        },
        pdfsNum: 0,
        linksNum: 8,
        videosNum: 3,
  },
  2: {
        title: "Lack of suitable green spaces for women and girls",
        description: "You are a young woman in your twenties or late teens heading to your favourite neighbourhood park to enjoy a beautiful day and have a lunch break. Once there, you see that all the seats are already taken by men or boys, and what is left are broken benches or wet, muddy grass patches to sit on. You are unhappy about not being able to enjoy a beautiful day outside and decide to go back to your home or workplace and stay inside.",
        question: "How can neighbourhood green spaces be designed to be more inviting for women and girls?",
        booklet: "documents/pdf/booklet.pdf",
        pdfs: {},
        links: {
          0: {
            name: 'How the inclusive city is planned in Europe and in our region?',
            path: 'https://www.gradnja.rs/planiranje-grada-po-meri-svih-ljudi-kako-se-to-radi-kod-nas-a-kako-u-evropi/'
          },
          1: {
            name: 'How Urban Planning Made One City Better for Women',
            path: 'https://slate.com/human-interest/2013/09/urban-planning-for-women-lets-all-move-to-vienna.html'
          },
          2: {
            name: 'Neglected perspective: how urban planning is ignoring needs of women and girls in public space',
            path: 'https://prostorikojipokrecu.ba/blog/zanemarena-perspektiva-kako-planiranje-prostora-ignorise-potrebe-djevojcica-i-zena/'
          },
          3: {
            name: 'News article: which places are most dangerous for women in Serbia?',
            path: 'https://www.telegraf.rs/vesti/srbija/3462231-1-u-10-devojcica-do-15-godina-trpi-onlajn-nasilje-zene-u-srbiji-otkrile-koja-su-najopasnija-mesta-za-njih'
          },
          4: {
            name: 'Public space must be safe for women- UN HABITAT BiH REPORT',
            path: 'https://bosniaherzegovina.un.org/bhs/199998-javni-prostor-mora-biti-siguran-za-%C5%Beene'
          },
          5: {
            name: 'From dusk till dawn: examining gender inequalities in urban nighttime economies - URBACT report abstract',
            path: 'https://urbact.eu/knowledge-hub/gender-equal-cities/dusk-till-dawn-examining-gender-inequalities-urban-nighttime-economies?utm_source=brevo&utm_campaign=URBACT%20newsletter'
          },
          6: {
            name: 'Women’s and girls’s safety',
            path: 'https://worldurbanparks.org/blog/womens-and-girls-safety/'
          },
          7: {
            name: 'Parks for Teens',
            path: 'https://www.childinthecity.org/2015/12/02/parks-for-teens-10-features-teens-want-to-see/?gdpr=deny'
          },
          8: {
            name: 'Listen to women stories',
            path: 'https://theconversation.com/to-design-safer-parks-for-women-city-planners-must-listen-to-their-stories-98317'
          },
          9: {
            name: 'How to design public spaces for girls',
            path: 'https://thiscitylife.ca/post/687162834878070784/how-to-design-public-spaces-for-girls'
          }
        },
        videos: {},
        pdfsNum: 0,
        linksNum: 10,
        videosNum: 0,
  },
  3: {
        title: "Lack of training and sensitivity in the police to deal with harassment.",
        description: "You are a university student walking home alone at night and feeling unsafe. You encounter concerning sexually inappropriate behaviours and call the police. However, they ask irrelevant questions and provide no support. Consequently, you live unease, fearing for your safety, and hesitate to speak out, believing little action will be taken.",
        question: "How can the victims feel safe in reporting and communicating about cases that take place towards them?",
        booklet: "documents/pdf/booklet.pdf",
        pdfs: {
          0: {
            name: 'Why training is not improving the police response to sexual violence against women: A glimpse into the ‘black box’ of police training',
            path: 'documents/situations/4/MAAT_Situation4_Resource1_2024.pdf'
          },
          1: {
            name: 'Data and Statistics on rape and attempted rape by European Women’s Lobby',
            path: 'documents/situations/4/MAAT_Situation4_Resource8_2024.pdf'
          },
          2: {
            name: 'The consequences of the covid-19 pandemic to the young migrant women living in cyprus',
            path: 'documents/situations/4/MAAT_Situation4_Resource9_2024.pdf'
          }
        },
        links:  {
          0: {
            name: 'Protection from Sexual Exploitation and Abuse (PSEA)',
            path: 'https://emergency.unhcr.org/protection/protection-principles/protection-sexual-exploitation-and-abuse-psea'
          },
          1: {
            name: 'Three women still seeking justice for sexual harassment cases',
            path: 'https://in-cyprus.philenews.com/local/three-women-still-seeking-justice-for-sexual-harassment-cases/'
          },
          2: {
            name: 'Cyprus: an attack on women everywhere',
            path: 'https://www.counterfire.org/article/cyprus-an-attack-on-women-everywhere/'
          },
          3: {
            name: 'The exposition of rape in Cyprus: From the crime scene to the courtroom',
            path: 'https://journals.sagepub.com/doi/full/10.1177/13657127231179284'
          },
          4: {
            name: 'Girls and women the majority of victims of violence and abuse',
            path: 'https://cyprus-mail.com/2023/03/08/girls-and-women-the-majority-of-victims-of-violence-and-abuse/'
          },
          5: {
            name: 'Violence against women in Cyprus: Despite positive developments, rape victims need more support says new report',
            path: 'https://www.coe.int/en/web/portal/-/violence-against-women-in-cyprus-despite-positive-developments-rape-victims-need-more-support-says-new-report'
          }
        },
        videos:  {
          0: {
            name: 'The Normalisation of Sexual Harassment of Women | Tobe Amamize | TEDxLSE',
            path: 'https://www.youtube.com/watch?v=6vJcDvaiVfI'
          }
        },
        pdfsNum: 3,
        linksNum: 6,
        videosNum: 1,
  },
  4: {
      title: "Sexual harassment against women and LGBTQIA+ people",
      description: "In a crowded subway car, a woman stands pressed against the doors, her discomfort evident as a man behind her leers and makes inappropriate comments. Despite her attempts to ignore him, he persists, invading her personal space with unwanted advances. The woman feels increasingly vulnerable and trapped as other passengers look away, unwilling to intervene. The harassment continues until she finally exits the train, shaken and distressed by the ordeal.",
      question: "How can we prevent and combat sexual harassement and violence against LGBTQIA+ people?",
      booklet: "documents/pdf/booklet.pdf",
      pdfs: {
        0: {
          name: 'A long way to go for LGBTI equality',
          path: 'documents/situations/0/MAAT_Situation0_Resource1_2020.pdf'
        },
        1: {
          name: 'Estudi sobre les agressions lgtbi-fòbiques del 01/01/2019 a 31/07/2019',
          path: 'documents/situations/0/MAAT_Situation0_Resource2_2019.pdf'
        },
        2: {
          name: 'Visibilitzem la lebofòbia. Compilaciò recerca qualitativa lesbofobia',
          path: 'documents/situations/0/MAAT_Situation0_Resource3_2021.pdf'
        },
        3: {
          name: 'Spatium urbis. Indagine sullo spazio urbano della città di Roma',
          path: 'documents/situations/0/MAAT_Situation0_Resource6_2024.pdf'
        },
        4: {
          name: 'Action on Equality: TfL’s Commitments to 2020',
          path: 'documents/situations/0/MAAT_Situation0_Resource9_2020.pdf'
        }
      },
      links: {
        0: {
          name: 'The feeling of insecurity in public transport in the Paris region in 2019',
          path: 'https://www.institutparisregion.fr/nos-travaux/publications/le-sentiment-dinsecurite-dans-les-transports-collectifs-franciliens-en-2019/'
        },
        1: {
          name: 'Women in European Transport with a focus on Research and Innovation',
          path: 'https://publications.jrc.ec.europa.eu/repository/handle/JRC117687'
        },
        2: {
          name: 'Examining women’s perception of safety during waiting times at public transport terminals',
          path: 'https://www.sciencedirect.com/science/article/abs/pii/S0967070X19307000',
        },
        3: {
          name: 'Transmobilities: mobility, harassment, and violence experienced by transgender and gender nonconforming public transit riders in Portland, Oregon',
          path: 'https://www.semanticscholar.org/paper/Transmobilities%3A-mobility%2C-harassment%2C-and-violence-Lubitow-Carathers/9ded58d6abb19871469795d3a8c5f9fb7ab7974f',
        },
        4: {
          name: 'Crime on Public Transport',
          path: 'https://link.springer.com/referenceworkentry/10.1007/978-1-4614-5690-2_301',
        }
      },
      pdfsNum: 5,
      linksNum: 5,
      videosNum: 0,
  },
}